<?php
// languages/de.php - German Language File
// فایل زبان آلمانی

return [
    // General
    'site_name' => 'Crashify',
    'welcome' => 'Willkommen',
    'home' => 'Startseite',
    'about' => 'Über uns',
    'contact' => 'Kontakt',
    'login' => 'Anmelden',
    'register' => 'Registrieren',
    'logout' => 'Abmelden',
    'dashboard' => 'Dashboard',
    'profile' => 'Profil',
    'settings' => 'Einstellungen',
    'help' => 'Hilfe',
    'support' => 'Support',
    'language' => 'Sprache',
    'currency' => 'Währung',
    'search' => 'Suchen',
    'loading' => 'Lädt...',
    'error' => 'Fehler',
    'success' => 'Erfolgreich',
    'warning' => 'Warnung',
    'info' => 'Information',
    'close' => 'Schließen',
    'save' => 'Speichern',
    'cancel' => 'Abbrechen',
    'delete' => 'Löschen',
    'edit' => 'Bearbeiten',
    'view' => 'Ansehen',
    'back' => 'Zurück',
    'next' => 'Weiter',
    'previous' => 'Vorherige',
    'submit' => 'Senden',
    'confirm' => 'Bestätigen',
    'yes' => 'Ja',
    'no' => 'Nein',
    'ok' => 'OK',
    'continue' => 'Fortfahren',
    'finish' => 'Beenden',
    'start' => 'Starten',
    'stop' => 'Stoppen',
    'pause' => 'Pausieren',
    'resume' => 'Fortsetzen',
    'reset' => 'Zurücksetzen',
    'refresh' => 'Aktualisieren',
    'update' => 'Aktualisieren',
    'upgrade' => 'Upgrade',
    'download' => 'Herunterladen',
    'upload' => 'Hochladen',
    'share' => 'Teilen',
    'copy' => 'Kopieren',
    'print' => 'Drucken',
    'export' => 'Exportieren',
    'import' => 'Importieren',
    
    // Navigation
    'nav_home' => 'Startseite',
    'nav_casino' => 'Casino',
    'nav_sports' => 'Sport',
    'nav_live' => 'Live',
    'nav_promotions' => 'Aktionen',
    'nav_wallet' => 'Geldbörse',
    'nav_history' => 'Verlauf',
    'nav_support' => 'Support',
    
    // Authentication
    'auth_login_title' => 'In Ihr Konto einloggen',
    'auth_register_title' => 'Neues Konto erstellen',
    'auth_email' => 'E-Mail',
    'auth_password' => 'Passwort',
    'auth_confirm_password' => 'Passwort bestätigen',
    'auth_remember_me' => 'Angemeldet bleiben',
    'auth_forgot_password' => 'Passwort vergessen?',
    'auth_no_account' => 'Kein Konto?',
    'auth_have_account' => 'Bereits ein Konto?',
    'auth_create_account' => 'Konto erstellen',
    'auth_login_now' => 'Jetzt anmelden',
    'auth_first_name' => 'Vorname',
    'auth_last_name' => 'Nachname',
    'auth_phone' => 'Telefonnummer',
    'auth_birth_date' => 'Geburtsdatum',
    'auth_country' => 'Land',
    'auth_city' => 'Stadt',
    'auth_address' => 'Adresse',
    'auth_agree_terms' => 'Ich stimme den AGB zu',
    'auth_agree_privacy' => 'Ich stimme der Datenschutzerklärung zu',
    'auth_login_success' => 'Erfolgreich angemeldet',
    'auth_register_success' => 'Konto erfolgreich erstellt',
    'auth_logout_success' => 'Erfolgreich abgemeldet',
    'auth_invalid_credentials' => 'Ungültige Anmeldedaten',
    'auth_email_exists' => 'E-Mail bereits verwendet',
    'auth_weak_password' => 'Schwaches Passwort',
    'auth_password_mismatch' => 'Passwörter stimmen nicht überein',
    
    // Dashboard
    'dashboard_welcome' => 'Willkommen, {name}',
    'dashboard_balance' => 'Guthaben',
    'dashboard_total_bets' => 'Gesamte Wetten',
    'dashboard_total_wins' => 'Gesamte Gewinne',
    'dashboard_win_rate' => 'Gewinnrate',
    'dashboard_recent_games' => 'Letzte Spiele',
    'dashboard_quick_deposit' => 'Schnelle Einzahlung',
    'dashboard_quick_withdraw' => 'Schnelle Auszahlung',
    'dashboard_notifications' => 'Benachrichtigungen',
    'dashboard_no_notifications' => 'Keine neuen Benachrichtigungen',
    'dashboard_view_all' => 'Alle anzeigen',
    
    // Games
    'games_crash' => 'Crash',
    'games_slots' => 'Spielautomaten',
    'games_blackjack' => 'Blackjack',
    'games_roulette' => 'Roulette',
    'games_baccarat' => 'Baccarat',
    'games_poker' => 'Poker',
    'games_dice' => 'Würfel',
    'games_mines' => 'Minen',
    'games_plinko' => 'Plinko',
    'games_wheel' => 'Rad',
    'games_keno' => 'Keno',
    'games_scratch' => 'Rubbellose',
    'games_play_now' => 'Jetzt spielen',
    'games_demo_mode' => 'Demo-Modus',
    'games_real_mode' => 'Echtgeld-Modus',
    'games_min_bet' => 'Min. Einsatz',
    'games_max_bet' => 'Max. Einsatz',
    'games_max_win' => 'Max. Gewinn',
    'games_rtp' => 'Auszahlungsquote',
    'games_volatility' => 'Volatilität',
    'games_provider' => 'Anbieter',
    
    // Betting
    'bet_amount' => 'Einsatzbetrag',
    'bet_place' => 'Wette platzieren',
    'bet_cancel' => 'Wette stornieren',
    'bet_cashout' => 'Auszahlen',
    'bet_auto' => 'Auto-Wette',
    'bet_manual' => 'Manuelle Wette',
    'bet_multiplier' => 'Multiplikator',
    'bet_profit' => 'Gewinn',
    'bet_loss' => 'Verlust',
    'bet_win' => 'Gewinn',
    'bet_pending' => 'Ausstehend',
    'bet_settled' => 'Abgerechnet',
    'bet_void' => 'Ungültig',
    'bet_history' => 'Wetthistorie',
    'bet_statistics' => 'Wettstatistiken',
    'bet_limits' => 'Wettlimits',
    'bet_responsible' => 'Verantwortungsvolles Spielen',
    
    // Wallet
    'wallet_balance' => 'Guthaben',
    'wallet_deposit' => 'Einzahlung',
    'wallet_withdraw' => 'Auszahlung',
    'wallet_transfer' => 'Überweisung',
    'wallet_history' => 'Transaktionshistorie',
    'wallet_pending' => 'Ausstehend',
    'wallet_completed' => 'Abgeschlossen',
    'wallet_failed' => 'Fehlgeschlagen',
    'wallet_cancelled' => 'Storniert',
    'wallet_min_deposit' => 'Min. Einzahlung',
    'wallet_max_deposit' => 'Max. Einzahlung',
    'wallet_min_withdraw' => 'Min. Auszahlung',
    'wallet_max_withdraw' => 'Max. Auszahlung',
    'wallet_fee' => 'Gebühr',
    'wallet_processing_time' => 'Bearbeitungszeit',
    'wallet_payment_method' => 'Zahlungsmethode',
    'wallet_card' => 'Karte',
    'wallet_bank' => 'Bank',
    'wallet_crypto' => 'Kryptowährung',
    'wallet_ewallet' => 'E-Wallet',
    
    // Sports Betting
    'sports_football' => 'Fußball',
    'sports_basketball' => 'Basketball',
    'sports_tennis' => 'Tennis',
    'sports_baseball' => 'Baseball',
    'sports_hockey' => 'Hockey',
    'sports_soccer' => 'American Football',
    'sports_boxing' => 'Boxen',
    'sports_mma' => 'Mixed Martial Arts',
    'sports_cricket' => 'Cricket',
    'sports_rugby' => 'Rugby',
    'sports_golf' => 'Golf',
    'sports_racing' => 'Rennsport',
    'sports_esports' => 'E-Sport',
    'sports_live_betting' => 'Live-Wetten',
    'sports_pre_match' => 'Vor dem Spiel',
    'sports_odds' => 'Quoten',
    'sports_handicap' => 'Handicap',
    'sports_over_under' => 'Über/Unter',
    'sports_both_teams_score' => 'Beide Teams treffen',
    'sports_correct_score' => 'Korrektes Ergebnis',
    'sports_first_goal' => 'Erstes Tor',
    'sports_match_winner' => 'Spielsieger',
    'sports_tournament_winner' => 'Turniersieger',
    
    // Promotions
    'promo_welcome_bonus' => 'Willkommensbonus',
    'promo_deposit_bonus' => 'Einzahlungsbonus',
    'promo_reload_bonus' => 'Reload-Bonus',
    'promo_cashback' => 'Cashback',
    'promo_free_spins' => 'Freispiele',
    'promo_free_bet' => 'Gratiswette',
    'promo_tournament' => 'Turnier',
    'promo_loyalty' => 'Treueprogramm',
    'promo_vip' => 'VIP-Programm',
    'promo_refer_friend' => 'Freund werben',
    'promo_code' => 'Promo-Code',
    'promo_terms' => 'Aktionsbedingungen',
    'promo_wagering' => 'Umsatzbedingungen',
    'promo_expiry' => 'Ablaufdatum',
    'promo_claim' => 'Beanspruchen',
    'promo_claimed' => 'Beansprucht',
    'promo_expired' => 'Abgelaufen',
    'promo_active' => 'Aktiv',
    'promo_completed' => 'Abgeschlossen',
    
    // Profile
    'profile_personal_info' => 'Persönliche Informationen',
    'profile_account_settings' => 'Kontoeinstellungen',
    'profile_security' => 'Sicherheit',
    'profile_preferences' => 'Einstellungen',
    'profile_verification' => 'Verifizierung',
    'profile_documents' => 'Dokumente',
    'profile_limits' => 'Limits',
    'profile_self_exclusion' => 'Selbstausschluss',
    'profile_responsible_gaming' => 'Verantwortungsvolles Spielen',
    'profile_notifications' => 'Benachrichtigungen',
    'profile_privacy' => 'Datenschutz',
    'profile_change_password' => 'Passwort ändern',
    'profile_two_factor' => 'Zwei-Faktor-Authentifizierung',
    'profile_login_history' => 'Anmeldeverlauf',
    'profile_device_management' => 'Geräteverwaltung',
    
    // Support
    'support_contact' => 'Kontakt aufnehmen',
    'support_live_chat' => 'Live-Chat',
    'support_email' => 'E-Mail',
    'support_phone' => 'Telefon',
    'support_faq' => 'Häufig gestellte Fragen',
    'support_help_center' => 'Hilfezentrum',
    'support_ticket' => 'Support-Ticket',
    'support_create_ticket' => 'Ticket erstellen',
    'support_ticket_status' => 'Ticket-Status',
    'support_priority' => 'Priorität',
    'support_category' => 'Kategorie',
    'support_subject' => 'Betreff',
    'support_message' => 'Nachricht',
    'support_attachment' => 'Anhang',
    'support_response' => 'Antwort',
    'support_resolved' => 'Gelöst',
    'support_pending' => 'Ausstehend',
    'support_closed' => 'Geschlossen',
    
    // Notifications
    'notif_new_message' => 'Neue Nachricht',
    'notif_deposit_success' => 'Einzahlung erfolgreich',
    'notif_withdraw_success' => 'Auszahlung erfolgreich',
    'notif_bet_won' => 'Wette gewonnen!',
    'notif_bet_lost' => 'Wette verloren',
    'notif_bonus_received' => 'Bonus erhalten',
    'notif_promotion_available' => 'Aktion verfügbar',
    'notif_account_verified' => 'Konto verifiziert',
    'notif_security_alert' => 'Sicherheitswarnung',
    'notif_maintenance' => 'Systemwartung',
    'notif_mark_read' => 'Als gelesen markieren',
    'notif_mark_all_read' => 'Alle als gelesen markieren',
    'notif_delete' => 'Benachrichtigung löschen',
    'notif_settings' => 'Benachrichtigungseinstellungen',
    
    // Errors
    'error_404' => 'Seite nicht gefunden',
    'error_500' => 'Serverfehler',
    'error_403' => 'Zugriff verweigert',
    'error_401' => 'Nicht autorisiert',
    'error_400' => 'Ungültige Anfrage',
    'error_network' => 'Netzwerkfehler',
    'error_timeout' => 'Zeitüberschreitung',
    'error_invalid_input' => 'Ungültige Eingabe',
    'error_required_field' => 'Dieses Feld ist erforderlich',
    'error_invalid_email' => 'Ungültige E-Mail',
    'error_invalid_phone' => 'Ungültige Telefonnummer',
    'error_min_length' => 'Mindestlänge {min} Zeichen',
    'error_max_length' => 'Maximale Länge {max} Zeichen',
    'error_min_value' => 'Mindestwert {min}',
    'error_max_value' => 'Maximalwert {max}',
    'error_insufficient_balance' => 'Unzureichendes Guthaben',
    'error_bet_limit_exceeded' => 'Wettlimit überschritten',
    'error_game_unavailable' => 'Spiel nicht verfügbar',
    'error_maintenance' => 'System in Wartung',
    
    // Success Messages
    'success_saved' => 'Erfolgreich gespeichert',
    'success_updated' => 'Erfolgreich aktualisiert',
    'success_deleted' => 'Erfolgreich gelöscht',
    'success_sent' => 'Erfolgreich gesendet',
    'success_verified' => 'Erfolgreich verifiziert',
    'success_activated' => 'Erfolgreich aktiviert',
    'success_deactivated' => 'Erfolgreich deaktiviert',
    'success_password_changed' => 'Passwort erfolgreich geändert',
    'success_email_sent' => 'E-Mail gesendet',
    'success_settings_saved' => 'Einstellungen gespeichert',
    
    // Time and Date
    'time_now' => 'jetzt',
    'time_minute_ago' => 'vor 1 Minute',
    'time_minutes_ago' => 'vor {count} Minuten',
    'time_hour_ago' => 'vor 1 Stunde',
    'time_hours_ago' => 'vor {count} Stunden',
    'time_day_ago' => 'vor 1 Tag',
    'time_days_ago' => 'vor {count} Tagen',
    'time_week_ago' => 'vor 1 Woche',
    'time_weeks_ago' => 'vor {count} Wochen',
    'time_month_ago' => 'vor 1 Monat',
    'time_months_ago' => 'vor {count} Monaten',
    'time_year_ago' => 'vor 1 Jahr',
    'time_years_ago' => 'vor {count} Jahren',
    
    // Days of Week
    'day_monday' => 'Montag',
    'day_tuesday' => 'Dienstag',
    'day_wednesday' => 'Mittwoch',
    'day_thursday' => 'Donnerstag',
    'day_friday' => 'Freitag',
    'day_saturday' => 'Samstag',
    'day_sunday' => 'Sonntag',
    
    // Months
    'month_january' => 'Januar',
    'month_february' => 'Februar',
    'month_march' => 'März',
    'month_april' => 'April',
    'month_may' => 'Mai',
    'month_june' => 'Juni',
    'month_july' => 'Juli',
    'month_august' => 'August',
    'month_september' => 'September',
    'month_october' => 'Oktober',
    'month_november' => 'November',
    'month_december' => 'Dezember',
    
    // Footer
    'footer_about_us' => 'Über uns',
    'footer_terms' => 'AGB',
    'footer_privacy' => 'Datenschutz',
    'footer_responsible_gaming' => 'Verantwortungsvolles Spielen',
    'footer_contact' => 'Kontakt',
    'footer_help' => 'Hilfe',
    'footer_sitemap' => 'Sitemap',
    'footer_copyright' => '© 2024 Crashify. Alle Rechte vorbehalten.',
    'footer_license' => 'Lizenziert und reguliert',
    'footer_18_plus' => 'Nur 18+',
    'footer_gamble_responsibly' => 'Spielen Sie verantwortungsvoll',
    
    // Legal
    'legal_terms_title' => 'Allgemeine Geschäftsbedingungen',
    'legal_privacy_title' => 'Datenschutzerklärung',
    'legal_responsible_title' => 'Verantwortungsvolles Spielen',
    'legal_aml_title' => 'Geldwäschebekämpfung',
    'legal_kyc_title' => 'Kundenidentifizierung',
    'legal_complaints_title' => 'Beschwerdeverfahren',
    'legal_licensing_title' => 'Lizenzinformationen',
    'legal_fairness_title' => 'Fairness und Transparenz',
    
    // Admin
    'admin_dashboard' => 'Admin-Dashboard',
    'admin_users' => 'Benutzer',
    'admin_transactions' => 'Transaktionen',
    'admin_games' => 'Spiele',
    'admin_reports' => 'Berichte',
    'admin_settings' => 'Einstellungen',
    'admin_logs' => 'Protokolle',
    'admin_security' => 'Sicherheit',
    'admin_maintenance' => 'Wartung',
    'admin_backup' => 'Sicherung',
];
?>
