<?php
// includes/header.php - Site Header
// هدر سایت

// Ensure we have access to global variables
global $pageTitle, $bodyClass, $breadcrumbs, $additionalScripts, $additionalStyles, $currentUser, $lang;

// Set default values if not set
$pageTitle = $pageTitle ?? 'Crashify - Crypto Sports Betting & Casino';
$bodyClass = $bodyClass ?? '';
$breadcrumbs = $breadcrumbs ?? [];
$additionalScripts = $additionalScripts ?? [];
$additionalStyles = $additionalStyles ?? [];

// Get current language
$currentLang = $_SESSION['language'] ?? 'en';
$langData = require_once __DIR__ . "/../languages/{$currentLang}.php";

// Get navigation items
$navItems = [
    'sportsbook' => [
        'title' => $langData['nav']['sportsbook'],
        'url' => '/pages/sportsbook.php',
        'icon' => 'fas fa-futbol',
        'active' => strpos($_SERVER['REQUEST_URI'], 'sportsbook') !== false
    ],
    'live_betting' => [
        'title' => $langData['nav']['live_betting'],
        'url' => '/pages/live-betting.php',
        'icon' => 'fas fa-broadcast-tower',
        'active' => strpos($_SERVER['REQUEST_URI'], 'live-betting') !== false,
        'badge' => 'LIVE'
    ],
    'casino' => [
        'title' => $langData['nav']['casino'],
        'url' => '/pages/casino.php',
        'icon' => 'fas fa-dice',
        'active' => strpos($_SERVER['REQUEST_URI'], 'casino') !== false
    ],
    'promotions' => [
        'title' => $langData['nav']['promotions'],
        'url' => '/pages/promotions.php',
        'icon' => 'fas fa-gift',
        'active' => strpos($_SERVER['REQUEST_URI'], 'promotions') !== false
    ],
    'vip' => [
        'title' => $langData['nav']['vip'],
        'url' => '/pages/vip.php',
        'icon' => 'fas fa-crown',
        'active' => strpos($_SERVER['REQUEST_URI'], 'vip') !== false
    ]
];

// Get user's unread notifications count
$notificationCount = 0;
if ($currentUser) {
    $notificationCount = fetchColumn(
        "SELECT COUNT(*) FROM notifications WHERE user_id = ? AND read_at IS NULL",
        [$currentUser['id']]
    ) ?: 0;
}
?>
<!DOCTYPE html>
<html lang="<?php echo $currentLang; ?>" dir="<?php echo $currentLang === 'fa' ? 'rtl' : 'ltr'; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Crashify - The ultimate crypto sports betting and casino platform. Bet on sports, play casino games, and win big with instant crypto payouts.">
    <meta name="keywords" content="crypto betting, sports betting, casino games, cryptocurrency, bitcoin, ethereum, live betting">
    <meta name="author" content="Crashify">
    
    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="<?php echo htmlspecialchars($pageTitle); ?>">
    <meta property="og:description" content="The ultimate crypto sports betting and casino platform with instant payouts.">
    <meta property="og:image" content="<?php echo SITE_URL; ?>/assets/images/og-image.jpg">
    <meta property="og:url" content="<?php echo SITE_URL . $_SERVER['REQUEST_URI']; ?>">
    <meta property="og:type" content="website">
    
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo htmlspecialchars($pageTitle); ?>">
    <meta name="twitter:description" content="The ultimate crypto sports betting and casino platform with instant payouts.">
    <meta name="twitter:image" content="<?php echo SITE_URL; ?>/assets/images/twitter-card.jpg">
    
    <title><?php echo htmlspecialchars($pageTitle); ?></title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'assets/images/favicon.ico">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'assets/images/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'assets/images/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'assets/images/favicon-16x16.png">
    
    <!-- Preconnect to external domains -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preconnect" href="https://cdnjs.cloudflare.com">
    
    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <!-- Main CSS -->
    <link href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'assets/css/main.css" rel="stylesheet">
    
    <!-- Additional Styles -->
    <?php foreach ($additionalStyles as $style): ?>
    <link href="<?php echo $style; ?>" rel="stylesheet">
    <?php endforeach; ?>
    
    <!-- Theme and Language -->
    <script>
        // Set initial theme and language
        document.documentElement.setAttribute('data-theme', localStorage.getItem('theme') || 'dark');
        document.documentElement.setAttribute('data-lang', '<?php echo $currentLang; ?>');
    </script>
</head>
<body class="<?php echo $bodyClass; ?>">
    <!-- Loading Screen -->
    <div id="loadingScreen" class="loading-screen">
        <div class="loading-content">
            <div class="loading-logo">
                <img src="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'assets/images/logo.svg" alt="Crashify">
            </div>
            <div class="loading-spinner">
                <div class="spinner"></div>
            </div>
            <div class="loading-text">Loading...</div>
        </div>
    </div>
    
    <!-- Header -->
    <header class="site-header" id="siteHeader">
        <div class="container">
            <div class="header-content">
                <!-- Logo -->
                <div class="header-logo">
                    <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'" class="logo-link">
                        <img src="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'assets/images/logo.svg" alt="Crashify" class="logo-img">
                        <span class="logo-text">Crashify</span>
                    </a>
                </div>
                
                <!-- Main Navigation -->
                <nav class="main-nav" id="mainNav">
                    <ul class="nav-list">
                        <?php foreach ($navItems as $key => $item): ?>
                        <li class="nav-item">
                            <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . $item['url']; ?>" 
                               class="nav-link <?php echo $item['active'] ? 'active' : ''; ?>">
                                <i class="<?php echo $item['icon']; ?>"></i>
                                <span><?php echo $item['title']; ?></span>
                                <?php if (isset($item['badge'])): ?>
                                <span class="nav-badge"><?php echo $item['badge']; ?></span>
                                <?php endif; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </nav>
                
                <!-- Header Actions -->
                <div class="header-actions">
                    <!-- Search -->
                    <div class="search-container">
                        <button class="search-toggle" onclick="toggleSearch()">
                            <i class="fas fa-search"></i>
                        </button>
                        <div class="search-dropdown" id="searchDropdown">
                            <div class="search-input">
                                <i class="fas fa-search"></i>
                                <input type="text" 
                                       placeholder="Search events, teams, games..." 
                                       id="globalSearch"
                                       autocomplete="off">
                                <button class="search-clear" onclick="clearSearch()">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                            <div class="search-results" id="searchResults">
                                <!-- Search results will be populated here -->
                            </div>
                        </div>
                    </div>
                    
                    <!-- Language Switcher -->
                    <div class="language-switcher">
                        <button class="lang-toggle" onclick="toggleLanguageMenu()">
                            <i class="fas fa-globe"></i>
                            <span><?php echo strtoupper($currentLang); ?></span>
                            <i class="fas fa-chevron-down"></i>
                        </button>
                        <div class="lang-dropdown" id="langDropdown">
                            <a href="?lang=en" class="lang-option <?php echo $currentLang === 'en' ? 'active' : ''; ?>">
                                <img src="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'assets/images/flags/en.svg" alt="English">
                                <span>English</span>
                            </a>
                            <a href="?lang=fa" class="lang-option <?php echo $currentLang === 'fa' ? 'active' : ''; ?>">
                                <img src="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'assets/images/flags/fa.svg" alt="فارسی">
                                <span>فارسی</span>
                            </a>
                        </div>
                    </div>
                    
                    <!-- Theme Toggle -->
                    <button class="theme-toggle" onclick="toggleTheme()" title="Toggle Theme">
                        <i class="fas fa-moon dark-icon"></i>
                        <i class="fas fa-sun light-icon"></i>
                    </button>
                    
                    <?php if ($currentUser): ?>
                    <!-- User Menu -->
                    <div class="user-menu">
                        <!-- Notifications -->
                        <div class="notifications-container">
                            <button class="notifications-toggle" onclick="toggleNotifications()">
                                <i class="fas fa-bell"></i>
                                <?php if ($notificationCount > 0): ?>
                                <span class="notification-badge"><?php echo $notificationCount > 99 ? '99+' : $notificationCount; ?></span>
                                <?php endif; ?>
                            </button>
                            <div class="notifications-dropdown" id="notificationsDropdown">
                                <div class="notifications-header">
                                    <h3>Notifications</h3>
                                    <?php if ($notificationCount > 0): ?>
                                    <button class="mark-all-read" onclick="markAllNotificationsRead()">
                                        Mark all read
                                    </button>
                                    <?php endif; ?>
                                </div>
                                <div class="notifications-list" id="notificationsList">
                                    <!-- Notifications will be loaded here -->
                                </div>
                            </div>
                        </div>
                        
                        <!-- User Balance -->
                        <div class="user-balance">
                            <div class="balance-item">
                                <i class="fas fa-wallet"></i>
                                <span class="balance-amount" id="headerBalance">
                                    $<?php echo number_format($currentUser['balance'], 2); ?>
                                </span>
                            </div>
                            <?php if ($currentUser['bonus_balance'] > 0): ?>
                            <div class="balance-item bonus">
                                <i class="fas fa-gift"></i>
                                <span class="balance-amount">
                                    $<?php echo number_format($currentUser['bonus_balance'], 2); ?>
                                </span>
                            </div>
                            <?php endif; ?>
                        </div>
                        
                        <!-- User Profile -->
                        <div class="user-profile">
                            <button class="profile-toggle" onclick="toggleUserMenu()">
                                <?php if ($currentUser['avatar']): ?>
                                <img src="<?php echo $currentUser['avatar']; ?>" alt="<?php echo $currentUser['username']; ?>" class="user-avatar">
                                <?php else: ?>
                                <div class="user-avatar-placeholder">
                                    <?php echo strtoupper(substr($currentUser['username'], 0, 2)); ?>
                                </div>
                                <?php endif; ?>
                                <span class="username"><?php echo $currentUser['username']; ?></span>
                                <?php if ($currentUser['vip_level']): ?>
                                <span class="vip-badge">VIP</span>
                                <?php endif; ?>
                                <i class="fas fa-chevron-down"></i>
                            </button>
                            <div class="user-dropdown" id="userDropdown">
                                <div class="user-info">
                                    <div class="user-details">
                                        <div class="username"><?php echo $currentUser['username']; ?></div>
                                        <div class="user-email"><?php echo $currentUser['email']; ?></div>
                                    </div>
                                    <?php if ($currentUser['vip_level']): ?>
                                    <div class="vip-status">
                                        <i class="fas fa-crown"></i>
                                        <span>VIP Level <?php echo $currentUser['vip_level']; ?></span>
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <div class="user-menu-items">
                                    <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/dashboard.php" class="menu-item">
                                        <i class="fas fa-tachometer-alt"></i>
                                        <span>Dashboard</span>
                                    </a>
                                    <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/profile.php" class="menu-item">
                                        <i class="fas fa-user"></i>
                                        <span>Profile</span>
                                    </a>
                                    <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/wallet.php" class="menu-item">
                                        <i class="fas fa-wallet"></i>
                                        <span>Wallet</span>
                                    </a>
                                    <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/bet-history.php" class="menu-item">
                                        <i class="fas fa-history"></i>
                                        <span>Bet History</span>
                                    </a>
                                    <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/settings.php" class="menu-item">
                                        <i class="fas fa-cog"></i>
                                        <span>Settings</span>
                                    </a>
                                    <div class="menu-divider"></div>
                                    <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'auth/logout.php" class="menu-item logout">
                                        <i class="fas fa-sign-out-alt"></i>
                                        <span>Logout</span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php else: ?>
                    <!-- Auth Buttons -->
                    <div class="auth-buttons">
                        <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'auth/login.php" class="btn btn-outline btn-sm">
                            <i class="fas fa-sign-in-alt"></i>
                            <span>Login</span>
                        </a>
                        <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'auth/register.php" class="btn btn-primary btn-sm">
                            <i class="fas fa-user-plus"></i>
                            <span>Sign Up</span>
                        </a>
                    </div>
                    <?php endif; ?>
                    
                    <!-- Mobile Menu Toggle -->
                    <button class="mobile-menu-toggle" onclick="toggleMobileMenu()">
                        <span class="hamburger-line"></span>
                        <span class="hamburger-line"></span>
                        <span class="hamburger-line"></span>
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Mobile Navigation -->
        <div class="mobile-nav" id="mobileNav">
            <div class="mobile-nav-content">
                <div class="mobile-nav-header">
                    <div class="mobile-logo">
                        <img src="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'assets/images/logo.svg" alt="Crashify">
                        <span>Crashify</span>
                    </div>
                    <button class="mobile-nav-close" onclick="toggleMobileMenu()">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                
                <div class="mobile-nav-body">
                    <?php if ($currentUser): ?>
                    <div class="mobile-user-info">
                        <div class="mobile-user-avatar">
                            <?php if ($currentUser['avatar']): ?>
                            <img src="<?php echo $currentUser['avatar']; ?>" alt="<?php echo $currentUser['username']; ?>">
                            <?php else: ?>
                            <div class="avatar-placeholder">
                                <?php echo strtoupper(substr($currentUser['username'], 0, 2)); ?>
                            </div>
                            <?php endif; ?>
                        </div>
                        <div class="mobile-user-details">
                            <div class="username"><?php echo $currentUser['username']; ?></div>
                            <div class="balance">$<?php echo number_format($currentUser['balance'], 2); ?></div>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <nav class="mobile-nav-menu">
                        <?php foreach ($navItems as $key => $item): ?>
                        <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . $item['url']; ?>" class="mobile-nav-item <?php echo $item['active'] ? 'active' : ''; ?>">
                            <i class="<?php echo $item['icon']; ?>"></i>
                            <span><?php echo $item['title']; ?></span>
                            <?php if (isset($item['badge'])): ?>
                            <span class="nav-badge"><?php echo $item['badge']; ?></span>
                            <?php endif; ?>
                        </a>
                        <?php endforeach; ?>
                        
                        <?php if ($currentUser): ?>
                        <div class="mobile-nav-divider"></div>
                        <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/dashboard.php" class="mobile-nav-item">
                            <i class="fas fa-tachometer-alt"></i>
                            <span>Dashboard</span>
                        </a>
                        <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/wallet.php" class="mobile-nav-item">
                            <i class="fas fa-wallet"></i>
                            <span>Wallet</span>
                        </a>
                        <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/profile.php" class="mobile-nav-item">
                            <i class="fas fa-user"></i>
                            <span>Profile</span>
                        </a>
                        <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'auth/logout.php" class="mobile-nav-item">
                            <i class="fas fa-sign-out-alt"></i>
                            <span>Logout</span>
                        </a>
                        <?php else: ?>
                        <div class="mobile-nav-divider"></div>
                        <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'auth/login.php" class="mobile-nav-item">
                            <i class="fas fa-sign-in-alt"></i>
                            <span>Login</span>
                        </a>
                        <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'auth/register.php" class="mobile-nav-item">
                            <i class="fas fa-user-plus"></i>
                            <span>Sign Up</span>
                        </a>
                        <?php endif; ?>
                    </nav>
                </div>
            </div>
        </div>
    </header>
    
    <!-- Breadcrumbs -->
    <?php if (!empty($breadcrumbs)): ?>
    <div class="breadcrumbs">
        <div class="container">
            <nav class="breadcrumb-nav">
                <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'" class="breadcrumb-item">
                    <i class="fas fa-home"></i>
                    <span>Home</span>
                </a>
                <?php foreach ($breadcrumbs as $crumb): ?>
                <i class="fas fa-chevron-right breadcrumb-separator"></i>
                <?php if (isset($crumb['url'])): ?>
                <a href="<?php echo $crumb['url']; ?>" class="breadcrumb-item">
                    <?php echo $crumb['title']; ?>
                </a>
                <?php else: ?>
                <span class="breadcrumb-item current"><?php echo $crumb['title']; ?></span>
                <?php endif; ?>
                <?php endforeach; ?>
            </nav>
        </div>
    </div>
    <?php endif; ?>
    