<?php
// pages/casino.php - Casino Games Page
// صفحه بازی‌های کازینو

require_once '../config/config.php';
require_once '../includes/functions.php';
require_once '../includes/auth.php';

// Page settings
$pageTitle = 'Casino Games - Slots, Table Games & Live Casino';
$bodyClass = 'casino-page';
$breadcrumbs = [
    ['title' => 'Casino']
];

// Get filters from URL
$selectedCategory = $_GET['category'] ?? 'all';
$selectedProvider = $_GET['provider'] ?? 'all';
$searchQuery = $_GET['search'] ?? '';
$sortBy = $_GET['sort'] ?? 'popular';
$viewMode = $_GET['view'] ?? 'grid';

// Get casino data
$categories = [
    'all' => ['name' => 'All Games', 'icon' => 'fas fa-th', 'count' => 0],
    'slots' => ['name' => 'Slots', 'icon' => 'fas fa-coins', 'count' => 0],
    'table' => ['name' => 'Table Games', 'icon' => 'fas fa-table', 'count' => 0],
    'live' => ['name' => 'Live Casino', 'icon' => 'fas fa-video', 'count' => 0],
    'crash' => ['name' => 'Crash Games', 'icon' => 'fas fa-chart-line', 'count' => 0],
    'jackpots' => ['name' => 'Jackpots', 'icon' => 'fas fa-trophy', 'count' => 0],
    'new' => ['name' => 'New Games', 'icon' => 'fas fa-star', 'count' => 0]
];

// Sample games data (in real app, this would come from database)
$games = [
    [
        'id' => 1,
        'name' => 'Sweet Bonanza',
        'provider' => 'Pragmatic Play',
        'category' => 'slots',
        'image' => '/assets/images/games/sweet-bonanza.jpg',
        'rtp' => 96.51,
        'volatility' => 'High',
        'min_bet' => 0.20,
        'max_bet' => 100.00,
        'jackpot' => null,
        'featured' => true,
        'new' => false,
        'popular' => true,
        'demo_available' => true
    ],
    [
        'id' => 2,
        'name' => 'Lightning Roulette',
        'provider' => 'Evolution Gaming',
        'category' => 'live',
        'image' => '/assets/images/games/lightning-roulette.jpg',
        'rtp' => 97.30,
        'volatility' => 'Medium',
        'min_bet' => 0.20,
        'max_bet' => 5000.00,
        'jackpot' => null,
        'featured' => true,
        'new' => false,
        'popular' => true,
        'demo_available' => false
    ],
    [
        'id' => 3,
        'name' => 'Aviator',
        'provider' => 'Spribe',
        'category' => 'crash',
        'image' => '/assets/images/games/aviator.jpg',
        'rtp' => 97.00,
        'volatility' => 'High',
        'min_bet' => 0.10,
        'max_bet' => 100.00,
        'jackpot' => null,
        'featured' => true,
        'new' => false,
        'popular' => true,
        'demo_available' => true
    ],
    [
        'id' => 4,
        'name' => 'Mega Moolah',
        'provider' => 'Microgaming',
        'category' => 'jackpots',
        'image' => '/assets/images/games/mega-moolah.jpg',
        'rtp' => 88.12,
        'volatility' => 'Medium',
        'min_bet' => 0.25,
        'max_bet' => 6.25,
        'jackpot' => 15420000.50,
        'featured' => true,
        'new' => false,
        'popular' => true,
        'demo_available' => true
    ],
    [
        'id' => 5,
        'name' => 'Blackjack Classic',
        'provider' => 'NetEnt',
        'category' => 'table',
        'image' => '/assets/images/games/blackjack-classic.jpg',
        'rtp' => 99.28,
        'volatility' => 'Low',
        'min_bet' => 1.00,
        'max_bet' => 1000.00,
        'jackpot' => null,
        'featured' => false,
        'new' => false,
        'popular' => true,
        'demo_available' => true
    ]
];

// Filter games
$filteredGames = array_filter($games, function($game) use ($selectedCategory, $selectedProvider, $searchQuery) {
    if ($selectedCategory !== 'all' && $game['category'] !== $selectedCategory) {
        return false;
    }
    if ($selectedProvider !== 'all' && $game['provider'] !== $selectedProvider) {
        return false;
    }
    if ($searchQuery && stripos($game['name'], $searchQuery) === false) {
        return false;
    }
    return true;
});

// Sort games
usort($filteredGames, function($a, $b) use ($sortBy) {
    switch ($sortBy) {
        case 'name':
            return strcmp($a['name'], $b['name']);
        case 'rtp':
            return $b['rtp'] <=> $a['rtp'];
        case 'newest':
            return $b['new'] <=> $a['new'];
        case 'popular':
        default:
            return $b['popular'] <=> $a['popular'];
    }
});

// Get providers
$providers = array_unique(array_column($games, 'provider'));
sort($providers);

// Update category counts
foreach ($games as $game) {
    $categories[$game['category']]['count']++;
    $categories['all']['count']++;
}

// Get featured games
$featuredGames = array_filter($games, fn($game) => $game['featured']);

// Additional scripts
$additionalScripts = [
    '/assets/js/casino.js'
];

include '../includes/header.php';
?>

<!-- Hero Section -->
<section class="casino-hero">
    <div class="container">
        <div class="hero-content">
            <div class="hero-text">
                <h1 class="hero-title">
                    <i class="fas fa-dice"></i>
                    Casino Games
                </h1>
                <p class="hero-description">
                    Experience the thrill of premium casino games with instant crypto payouts. 
                    From classic slots to live dealer games, we have it all.
                </p>
                <div class="hero-features">
                    <div class="feature-item">
                        <i class="fas fa-bolt"></i>
                        <span>Instant Payouts</span>
                    </div>
                    <div class="feature-item">
                        <i class="fas fa-shield-alt"></i>
                        <span>Provably Fair</span>
                    </div>
                    <div class="feature-item">
                        <i class="fas fa-mobile-alt"></i>
                        <span>Mobile Optimized</span>
                    </div>
                    <div class="feature-item">
                        <i class="fas fa-headset"></i>
                        <span>24/7 Support</span>
                    </div>
                </div>
            </div>
            <div class="hero-image">
                <div class="floating-games">
                    <div class="game-card floating">
                        <img src="/assets/images/games/sweet-bonanza.jpg" alt="Sweet Bonanza">
                        <div class="game-overlay">
                            <button class="play-btn">
                                <i class="fas fa-play"></i>
                            </button>
                        </div>
                    </div>
                    <div class="game-card floating" style="animation-delay: 0.5s;">
                        <img src="/assets/images/games/lightning-roulette.jpg" alt="Lightning Roulette">
                        <div class="game-overlay">
                            <button class="play-btn">
                                <i class="fas fa-play"></i>
                            </button>
                        </div>
                    </div>
                    <div class="game-card floating" style="animation-delay: 1s;">
                        <img src="/assets/images/games/aviator.jpg" alt="Aviator">
                        <div class="game-overlay">
                            <button class="play-btn">
                                <i class="fas fa-play"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Categories Navigation -->
<section class="categories-nav">
    <div class="container">
        <div class="categories-tabs">
            <?php foreach ($categories as $key => $category): ?>
            <a href="?category=<?php echo $key; ?>" 
               class="category-tab <?php echo $selectedCategory === $key ? 'active' : ''; ?>">
                <i class="<?php echo $category['icon']; ?>"></i>
                <span><?php echo $category['name']; ?></span>
                <span class="game-count"><?php echo $category['count']; ?></span>
            </a>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- Jackpot Ticker -->
<section class="jackpot-ticker">
    <div class="container">
        <div class="ticker-content">
            <div class="ticker-title">
                <i class="fas fa-trophy"></i>
                <span>Progressive Jackpots</span>
            </div>
            <div class="jackpots-list">
                <div class="jackpot-item">
                    <span class="game-name">Mega Moolah</span>
                    <span class="jackpot-amount" data-jackpot="15420000.50">$15,420,000.50</span>
                </div>
                <div class="jackpot-item">
                    <span class="game-name">Divine Fortune</span>
                    <span class="jackpot-amount" data-jackpot="2850000.25">$2,850,000.25</span>
                </div>
                <div class="jackpot-item">
                    <span class="game-name">Hall of Gods</span>
                    <span class="jackpot-amount" data-jackpot="1250000.75">$1,250,000.75</span>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Featured Games -->
<?php if (!empty($featuredGames) && $selectedCategory === 'all' && empty($searchQuery)): ?>
<section class="featured-games">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">
                <i class="fas fa-star"></i>
                Featured Games
            </h2>
            <div class="section-actions">
                <button class="carousel-btn prev" onclick="scrollCarousel('featured', 'prev')">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button class="carousel-btn next" onclick="scrollCarousel('featured', 'next')">
                    <i class="fas fa-chevron-right"></i>
                </button>
            </div>
        </div>
        
        <div class="games-carousel" id="featuredCarousel">
            <?php foreach ($featuredGames as $game): ?>
            <div class="game-card featured" data-game-id="<?php echo $game['id']; ?>">
                <div class="game-image">
                    <img src="<?php echo $game['image']; ?>" alt="<?php echo $game['name']; ?>">
                    <div class="game-overlay">
                        <div class="game-actions">
                            <?php if ($game['demo_available']): ?>
                            <button class="btn btn-outline btn-sm" onclick="playDemo(<?php echo $game['id']; ?>)">
                                <i class="fas fa-play"></i>
                                Demo
                            </button>
                            <?php endif; ?>
                            <button class="btn btn-primary btn-sm" onclick="playReal(<?php echo $game['id']; ?>)">
                                <i class="fas fa-coins"></i>
                                Play
                            </button>
                        </div>
                    </div>
                    <?php if ($game['new']): ?>
                    <span class="game-badge new">NEW</span>
                    <?php endif; ?>
                    <?php if ($game['jackpot']): ?>
                    <span class="game-badge jackpot">JACKPOT</span>
                    <?php endif; ?>
                </div>
                <div class="game-info">
                    <h3 class="game-title"><?php echo $game['name']; ?></h3>
                    <p class="game-provider"><?php echo $game['provider']; ?></p>
                    <div class="game-stats">
                        <div class="stat">
                            <span class="label">RTP:</span>
                            <span class="value"><?php echo $game['rtp']; ?>%</span>
                        </div>
                        <?php if ($game['jackpot']): ?>
                        <div class="stat jackpot">
                            <span class="label">Jackpot:</span>
                            <span class="value">$<?php echo number_format($game['jackpot'], 2); ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Filters & Search -->
<section class="filters-section">
    <div class="container">
        <div class="filters-bar">
            <div class="filter-group">
                <label class="filter-label">Provider:</label>
                <select class="filter-select" id="providerFilter" onchange="applyFilters()">
                    <option value="all">All Providers</option>
                    <?php foreach ($providers as $provider): ?>
                    <option value="<?php echo $provider; ?>" <?php echo $selectedProvider === $provider ? 'selected' : ''; ?>>
                        <?php echo $provider; ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <div class="filter-group">
                <label class="filter-label">Sort by:</label>
                <select class="filter-select" id="sortFilter" onchange="applyFilters()">
                    <option value="popular" <?php echo $sortBy === 'popular' ? 'selected' : ''; ?>>Most Popular</option>
                    <option value="newest" <?php echo $sortBy === 'newest' ? 'selected' : ''; ?>>Newest</option>
                    <option value="name" <?php echo $sortBy === 'name' ? 'selected' : ''; ?>>A-Z</option>
                    <option value="rtp" <?php echo $sortBy === 'rtp' ? 'selected' : ''; ?>>Highest RTP</option>
                </select>
            </div>
            
            <div class="search-group">
                <div class="search-input">
                    <i class="fas fa-search"></i>
                    <input type="text" 
                           placeholder="Search games..." 
                           value="<?php echo htmlspecialchars($searchQuery); ?>"
                           id="searchInput"
                           onkeyup="handleSearch(event)">
                    <?php if ($searchQuery): ?>
                    <button class="clear-search" onclick="clearSearch()">
                        <i class="fas fa-times"></i>
                    </button>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="view-toggle">
                <button class="view-btn <?php echo $viewMode === 'grid' ? 'active' : ''; ?>" 
                        onclick="changeView('grid')" data-view="grid">
                    <i class="fas fa-th"></i>
                </button>
                <button class="view-btn <?php echo $viewMode === 'list' ? 'active' : ''; ?>" 
                        onclick="changeView('list')" data-view="list">
                    <i class="fas fa-list"></i>
                </button>
            </div>
        </div>
    </div>
</section>

<!-- Games Grid -->
<section class="games-section">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">
                <?php 
                if ($selectedCategory !== 'all') {
                    echo $categories[$selectedCategory]['name'];
                } else {
                    echo 'All Games';
                }
                ?>
                <?php if ($searchQuery): ?>
                <span class="search-results">- Results for "<?php echo htmlspecialchars($searchQuery); ?>"</span>
                <?php endif; ?>
            </h2>
            <div class="results-count">
                <?php echo count($filteredGames); ?> games found
            </div>
        </div>
        
        <?php if (empty($filteredGames)): ?>
        <div class="empty-state">
            <div class="empty-icon">
                <i class="fas fa-gamepad"></i>
            </div>
            <h3>No Games Found</h3>
            <p>
                <?php if ($searchQuery): ?>
                    No games match your search criteria. Try adjusting your search terms.
                <?php else: ?>
                    No games available for the selected filters. Try changing your selection.
                <?php endif; ?>
            </p>
            <div class="empty-actions">
                <?php if ($searchQuery): ?>
                <button class="btn btn-primary" onclick="clearSearch()">Clear Search</button>
                <?php endif; ?>
                <a href="/pages/casino.php" class="btn btn-outline">View All Games</a>
            </div>
        </div>
        <?php else: ?>
        <div class="games-grid <?php echo $viewMode; ?>-view" id="gamesGrid">
            <?php foreach ($filteredGames as $game): ?>
            <div class="game-card" data-game-id="<?php echo $game['id']; ?>">
                <div class="game-image">
                    <img src="<?php echo $game['image']; ?>" alt="<?php echo $game['name']; ?>" loading="lazy">
                    <div class="game-overlay">
                        <div class="game-actions">
                            <?php if ($game['demo_available']): ?>
                            <button class="btn btn-outline btn-sm" onclick="playDemo(<?php echo $game['id']; ?>)">
                                <i class="fas fa-play"></i>
                                Demo
                            </button>
                            <?php endif; ?>
                            <button class="btn btn-primary btn-sm" onclick="playReal(<?php echo $game['id']; ?>)">
                                <i class="fas fa-coins"></i>
                                <?php echo $currentUser ? 'Play' : 'Login to Play'; ?>
                            </button>
                        </div>
                        <button class="favorite-btn" onclick="toggleFavorite(<?php echo $game['id']; ?>)">
                            <i class="far fa-heart"></i>
                        </button>
                    </div>
                    
                    <!-- Game Badges -->
                    <div class="game-badges">
                        <?php if ($game['new']): ?>
                        <span class="game-badge new">NEW</span>
                        <?php endif; ?>
                        <?php if ($game['jackpot']): ?>
                        <span class="game-badge jackpot">JACKPOT</span>
                        <?php endif; ?>
                        <?php if ($game['popular']): ?>
                        <span class="game-badge popular">HOT</span>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="game-info">
                    <h3 class="game-title"><?php echo $game['name']; ?></h3>
                    <p class="game-provider"><?php echo $game['provider']; ?></p>
                    
                    <div class="game-stats">
                        <div class="stat">
                            <span class="label">RTP:</span>
                            <span class="value"><?php echo $game['rtp']; ?>%</span>
                        </div>
                        <div class="stat">
                            <span class="label">Volatility:</span>
                            <span class="value volatility-<?php echo strtolower($game['volatility']); ?>">
                                <?php echo $game['volatility']; ?>
                            </span>
                        </div>
                    </div>
                    
                    <div class="game-limits">
                        <span class="min-bet">Min: $<?php echo number_format($game['min_bet'], 2); ?></span>
                        <span class="max-bet">Max: $<?php echo number_format($game['max_bet'], 2); ?></span>
                    </div>
                    
                    <?php if ($game['jackpot']): ?>
                    <div class="jackpot-amount">
                        <i class="fas fa-trophy"></i>
                        <span>$<?php echo number_format($game['jackpot'], 2); ?></span>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        
        <!-- Load More Button -->
        <div class="load-more-section">
            <button class="btn btn-outline load-more-btn" onclick="loadMoreGames()">
                <i class="fas fa-plus"></i>
                Load More Games
            </button>
        </div>
        <?php endif; ?>
    </div>
</section>

<!-- Game Modal -->
<div class="modal-backdrop" id="gameModal">
    <div class="modal game-modal">
        <div class="modal-header">
            <h3 class="modal-title" id="gameModalTitle">Game</h3>
            <button class="modal-close" onclick="closeGameModal()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="modal-body">
            <div class="game-container" id="gameContainer">
                <!-- Game iframe will be loaded here -->
            </div>
        </div>
    </div>
</div>

<script>
// Page-specific JavaScript
document.addEventListener('DOMContentLoaded', function() {
    // Initialize casino functionality
    initializeCasino();
    
    // Update jackpot amounts
    setInterval(updateJackpots, 10000); // Every 10 seconds
    
    // Initialize filters
    initializeFilters();
});

function initializeCasino() {
    // Initialize game cards
    initializeGameCards();
    
    // Initialize carousels
    initializeCarousels();
    
    // Initialize search
    initializeSearch();
}

function playDemo(gameId) {
    // Load game in demo mode
    loadGame(gameId, 'demo');
}

function playReal(gameId) {
    <?php if (!$currentUser): ?>
    // Redirect to login if not authenticated
    window.location.href = '/auth/login.php?redirect=' + encodeURIComponent(window.location.href);
    return;
    <?php endif; ?>
    
    // Load game in real mode
    loadGame(gameId, 'real');
}

function loadGame(gameId, mode) {
    // Show loading
    Crashify.ui.showLoading();
    
    // Load game
    Crashify.api.request(`/api/games/${gameId}/launch`, {
        method: 'POST',
        body: JSON.stringify({ mode: mode })
    })
    .then(response => {
        if (response.success) {
            document.getElementById('gameContainer').innerHTML = response.html;
            document.getElementById('gameModalTitle').textContent = response.game.name;
            openModal('gameModal');
        } else {
            throw new Error(response.message);
        }
    })
    .catch(error => {
        Crashify.ui.toast.error(error.message || 'Failed to load game');
    })
    .finally(() => {
        Crashify.ui.hideLoading();
    });
}

function closeGameModal() {
    // Stop game
    const gameContainer = document.getElementById('gameContainer');
    gameContainer.innerHTML = '';
    
    // Close modal
    closeModal('gameModal');
}

function applyFilters() {
    const category = '<?php echo $selectedCategory; ?>';
    const provider = document.getElementById('providerFilter').value;
    const sort = document.getElementById('sortFilter').value;
    const search = document.getElementById('searchInput').value;
    
    const params = new URLSearchParams();
    if (category !== 'all') params.set('category', category);
    if (provider !== 'all') params.set('provider', provider);
    if (sort !== 'popular') params.set('sort', sort);
    if (search) params.set('search', search);
    
    window.location.href = `${window.location.pathname}?${params.toString()}`;
}

function handleSearch(event) {
    if (event.key === 'Enter') {
        applyFilters();
    }
}

function clearSearch() {
    document.getElementById('searchInput').value = '';
    applyFilters();
}

function changeView(viewMode) {
    const params = new URLSearchParams(window.location.search);
    params.set('view', viewMode);
    window.location.href = `${window.location.pathname}?${params.toString()}`;
}

function toggleFavorite(gameId) {
    <?php if (!$currentUser): ?>
    Crashify.ui.toast.error('Please login to add favorites');
    return;
    <?php endif; ?>
    
    Crashify.api.request(`/api/games/${gameId}/favorite`, {
        method: 'POST'
    })
    .then(response => {
        if (response.success) {
            const btn = event.target.closest('.favorite-btn');
            const icon = btn.querySelector('i');
            
            if (response.favorited) {
                icon.className = 'fas fa-heart';
                Crashify.ui.toast.success('Added to favorites');
            } else {
                icon.className = 'far fa-heart';
                Crashify.ui.toast.success('Removed from favorites');
            }
        }
    })
    .catch(error => {
        Crashify.ui.toast.error('Failed to update favorites');
    });
}

function updateJackpots() {
    // Update progressive jackpot amounts
    Crashify.api.request('/api/jackpots/current')
        .then(response => {
            if (response.success) {
                response.jackpots.forEach(jackpot => {
                    const elements = document.querySelectorAll(`[data-jackpot="${jackpot.game_id}"]`);
                    elements.forEach(el => {
                        el.textContent = '$' + jackpot.amount.toLocaleString();
                    });
                });
            }
        })
        .catch(error => {
            console.error('Failed to update jackpots:', error);
        });
}
</script>

<?php include '../includes/footer.php'; ?>