<?php
// config/config.php - Site Configuration File
// تنظیمات اصلی سایت شرط بندی Crashify

// Site Information
define('SITE_NAME', 'Crashify');
define('SITE_URL', 'https://mifrestamet.co.uk/crashify');
define('SITE_DESCRIPTION', 'The ultimate crypto betting platform');
define('SITE_KEYWORDS', 'crypto betting, sports betting, casino, live betting');
define('SITE_AUTHOR', 'Crashify Team');
define('SITE_VERSION', '2.0.0');

// Security Settings
define('SECRET_KEY', 'your-secret-key-here-change-this');
define('JWT_SECRET', 'your-jwt-secret-here-change-this');
define('ENCRYPTION_KEY', 'your-encryption-key-here-change-this');
define('SESSION_LIFETIME', 3600 * 24 * 7); // 7 days
define('MAX_LOGIN_ATTEMPTS', 5);
define('LOGIN_LOCKOUT_TIME', 900); // 15 minutes

// Database Settings (imported from database.php)
require_once 'database.php';

// Email Settings
define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587);
define('SMTP_USERNAME', 'Crashify2025@gmail.com');
define('SMTP_PASSWORD', 'tiam1017#');
define('FROM_EMAIL', 'noreply@crashify.com');
define('FROM_NAME', 'Crashify');

// Crypto Settings
define('BITCOIN_NETWORK', 'mainnet'); // mainnet or testnet
define('ETHEREUM_NETWORK', 'mainnet');
define('MIN_DEPOSIT_BTC', 0.001);
define('MIN_DEPOSIT_ETH', 0.01);
define('MIN_DEPOSIT_USDT', 10);
define('MIN_WITHDRAWAL_BTC', 0.001);
define('MIN_WITHDRAWAL_ETH', 0.01);
define('MIN_WITHDRAWAL_USDT', 10);

// Betting Settings
define('MIN_BET_AMOUNT', 1);
define('MAX_BET_AMOUNT', 10000);
define('MAX_PAYOUT', 100000);
define('HOUSE_EDGE', 0.02); // 2%
define('MAX_ODDS', 1000);

// File Upload Settings
define('MAX_FILE_SIZE', 5 * 1024 * 1024); // 5MB
define('ALLOWED_IMAGE_TYPES', ['jpg', 'jpeg', 'png', 'gif', 'webp']);
define('UPLOAD_PATH', '../uploads/');

// Cache Settings
define('CACHE_ENABLED', true);
define('CACHE_LIFETIME', 3600); // 1 hour
define('REDIS_HOST', '127.0.0.1');
define('REDIS_PORT', 6379);

// API Settings
define('SPORTS_API_KEY', 'your-sports-api-key');
define('ODDS_API_KEY', 'your-odds-api-key');
define('CRYPTO_API_KEY', 'your-crypto-api-key');
define('API_RATE_LIMIT', 1000); // requests per hour

// Language Settings
define('DEFAULT_LANGUAGE', 'en');
define('SUPPORTED_LANGUAGES', [
    'en' => 'English',
    'fa' => 'فارسی',
    'ar' => 'العربية',
    'tr' => 'Türkçe',
    'ru' => 'Русский',
    'de' => 'Deutsch',
    'fr' => 'Français',
    'es' => 'Español'
]);

// Theme Settings
define('DEFAULT_THEME', 'blue');
define('AVAILABLE_THEMES', [
    'blue' => '#00d4ff',
    'purple' => '#8b5cf6',
    'green' => '#10b981',
    'orange' => '#f59e0b',
    'red' => '#ef4444',
    'pink' => '#ec4899',
    'indigo' => '#6366f1',
    'teal' => '#14b8a6',
    'yellow' => '#eab308',
    'cyan' => '#06b6d4'
]);

// Time Settings
define('DEFAULT_TIMEZONE', 'UTC');
date_default_timezone_set(DEFAULT_TIMEZONE);

// Error Reporting
if (defined('DEVELOPMENT') && DEVELOPMENT) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
    ini_set('log_errors', 1);
    ini_set('error_log', '../logs/error.log');
}

// Session Configuration
ini_set('session.cookie_httponly', 1);
ini_set('session.cookie_secure', 1);
ini_set('session.use_strict_mode', 1);
ini_set('session.cookie_samesite', 'Strict');

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Helper Functions
function getSiteConfig($key, $default = null) {
    $configs = [
        'site_name' => SITE_NAME,
        'site_url' => SITE_URL,
        'site_description' => SITE_DESCRIPTION,
        'default_language' => DEFAULT_LANGUAGE,
        'default_theme' => DEFAULT_THEME,
        'supported_languages' => SUPPORTED_LANGUAGES,
        'available_themes' => AVAILABLE_THEMES
    ];
    
    return isset($configs[$key]) ? $configs[$key] : $default;
}

function isProduction() {
    return !defined('DEVELOPMENT') || !DEVELOPMENT;
}

function getBaseUrl() {
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    $path = dirname($_SERVER['SCRIPT_NAME']);
    return $protocol . '://' . $host . $path;
}
?>