<?php
require_once 'includes/header.php';

if ($auth->isLoggedIn()) {
    header("Location: dashboard.php");
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);
    
    if (!empty($username) && !empty($password)) {
        if ($auth->login($username, $password)) {
            header("Location: dashboard.php");
            exit;
        } else {
            $error = "نام کاربری یا رمز عبور اشتباه است.";
        }
    } else {
        $error = "لطفا تمام فیلدها را پر کنید.";
    }
}
?>

<div class="container">
    <div class="form-container">
        <h2 data-translate="login">Login</h2>
        
        <?php if (!empty($error)): ?>
            <div class="alert alert-error"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <form method="POST">
            <div class="form-group">
                <label for="username" data-translate="username">Username</label>
                <input type="text" id="username" name="username" required>
            </div>
            
            <div class="form-group">
                <label for="password" data-translate="password">Password</label>
                <input type="password" id="password" name="password" required>
            </div>
            
            <div class="form-group">
                <label>
                    <input type="checkbox" name="remember">
                    <span data-translate="remember_me">Remember me</span>
                </label>
            </div>
            
            <button type="submit" class="form-button" data-translate="login">Login</button>
        </form>
        
        <div class="form-footer">
            <p>
                <span data-translate="no_account">Don't have an account?</span>
                <a href="register.php" data-translate="register">Register</a>
            </p>
            <p>
                <a href="forgot_password.php" data-translate="forgot_password">Forgot your password?</a>
            </p>
        </div>
    </div>
</div>

<?php
require_once 'includes/footer.php';
?>