<?php
require_once 'config.php';
require_once 'auth.php';
require_once 'functions.php';

$auth = new Auth();
$functions = new Functions();

// دریافت ترجمه‌ها
$lang = $_SESSION['language'] ?? DEFAULT_LANGUAGE;
require_once "../lang/$lang.php";

// دریافت تم فعال
$theme = $_SESSION['theme'] ?? 'default';
$themeColors = json_decode(THEME_COLORS, true)[$theme];
?>

<!DOCTYPE html>
<html lang="<?php echo $lang; ?>" dir="<?php echo in_array($lang, ['fa', 'ar']) ? 'rtl' : 'ltr'; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo SITE_NAME; ?> - <?php echo $translations['crash_game']; ?></title>
    
    <!-- فونت‌آیкон -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- فونت‌های گوگل -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Samim&display=swap" rel="stylesheet">
    
    <!-- کتابخانه‌های CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">
    
    <!-- استایل‌های اصلی -->
    <link rel="stylesheet" href="<?php echo SITE_URL; ?>/public/css/style.css">
    <link rel="stylesheet" href="<?php echo SITE_URL; ?>/public/css/theme.css">
    
    <!-- اسکریپت‌های ضروری -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
    
    <style>
        :root {
            --primary: <?php echo $themeColors['primary']; ?>;
            --secondary: <?php echo $themeColors['secondary']; ?>;
            --accent: <?php echo $themeColors['accent']; ?>;
            --background: <?php echo $themeColors['background']; ?>;
            --text: <?php echo $themeColors['text']; ?>;
            --success: <?php echo $themeColors['success']; ?>;
            --warning: <?php echo $themeColors['warning']; ?>;
            --error: <?php echo $themeColors['error']; ?>;
        }
    </style>
</head>
<body class="theme-<?php echo $theme; ?>">
    <!-- نویگیشن اصلی -->
    <nav class="main-nav">
        <div class="nav-container">
            <!-- لوگو -->
            <div class="nav-brand">
                <a href="<?php echo SITE_URL; ?>">
                    <img src="<?php echo SITE_URL; ?>/public/images/logo.png" alt="Crashify" class="logo">
                    <span class="brand-text">Crashify</span>
                </a>
            </div>

            <!-- منوی اصلی -->
            <div class="nav-menu">
                <a href="<?php echo SITE_URL; ?>" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : ''; ?>">
                    <i class="fas fa-home"></i>
                    <span><?php echo $translations['home']; ?></span>
                </a>
                
                <a href="<?php echo SITE_URL; ?>/casino.php" class="nav-item">
                    <i class="fas fa-dice"></i>
                    <span>کازینو</span>
                </a>
                
                <a href="<?php echo SITE_URL; ?>/sports.php" class="nav-item">
                    <i class="fas fa-trophy"></i>
                    <span>ورزشی</span>
                </a>
                
                <a href="<?php echo SITE_URL; ?>/live.php" class="nav-item">
                    <i class="fas fa-video"></i>
                    <span>زنده</span>
                </a>
                
                <a href="<?php echo SITE_URL; ?>/promotions.php" class="nav-item">
                    <i class="fas fa-gift"></i>
                    <span>پromoها</span>
                </a>
            </div>

            <!-- بخش کاربری -->
            <div class="nav-user">
                <?php if ($auth->isLoggedIn()): ?>
                    <div class="user-dropdown">
                        <button class="user-btn">
                            <div class="user-avatar">
                                <i class="fas fa-user"></i>
                            </div>
                            <span class="user-name"><?php echo $_SESSION['username']; ?></span>
                            <span class="user-balance">$<?php echo number_format($_SESSION['balance'], 2); ?></span>
                            <i class="fas fa-chevron-down"></i>
                        </button>
                        
                        <div class="dropdown-menu">
                            <a href="<?php echo SITE_URL; ?>/dashboard.php" class="dropdown-item">
                                <i class="fas fa-tachometer-alt"></i>
                                <span><?php echo $translations['dashboard']; ?></span>
                            </a>
                            <a href="<?php echo SITE_URL; ?>/profile.php" class="dropdown-item">
                                <i class="fas fa-user-circle"></i>
                                <span><?php echo $translations['profile']; ?></span>
                            </a>
                            <a href="<?php echo SITE_URL; ?>/wallet.php" class="dropdown-item">
                                <i class="fas fa-wallet"></i>
                                <span>کیف پول</span>
                            </a>
                            <a href="<?php echo SITE_URL; ?>/history.php" class="dropdown-item">
                                <i class="fas fa-history"></i>
                                <span><?php echo $translations['history']; ?></span>
                            </a>
                            <div class="dropdown-divider"></div>
                            <?php if ($auth->isAdmin()): ?>
                                <a href="<?php echo SITE_URL; ?>/admin/" class="dropdown-item">
                                    <i class="fas fa-crown"></i>
                                    <span><?php echo $translations['admin_panel']; ?></span>
                                </a>
                                <div class="dropdown-divider"></div>
                            <?php endif; ?>
                            <a href="<?php echo SITE_URL; ?>/logout.php" class="dropdown-item">
                                <i class="fas fa-sign-out-alt"></i>
                                <span><?php echo $translations['logout']; ?></span>
                            </a>
                        </div>
                    </div>
                    
                    <button class="btn-deposit" onclick="openDepositModal()">
                        <i class="fas fa-plus"></i>
                        <span>واریز</span>
                    </button>
                <?php else: ?>
                    <div class="auth-buttons">
                        <a href="<?php echo SITE_URL; ?>/login.php" class="btn-login">
                            <i class="fas fa-sign-in-alt"></i>
                            <span><?php echo $translations['login']; ?></span>
                        </a>
                        <a href="<?php echo SITE_URL; ?>/register.php" class="btn-register">
                            <i class="fas fa-user-plus"></i>
                            <span><?php echo $translations['register']; ?></span>
                        </a>
                    </div>
                <?php endif; ?>
                
                <!-- انتخابگر زبان -->
                <div class="language-selector">
                    <select id="languageSelector" class="lang-select">
                        <option value="en" <?php echo $lang == 'en' ? 'selected' : ''; ?>>English</option>
                        <option value="fa" <?php echo $lang == 'fa' ? 'selected' : ''; ?>>فارسی</option>
                        <option value="ar" <?php echo $lang == 'ar' ? 'selected' : ''; ?>>العربية</option>
                        <option value="tr" <?php echo $lang == 'tr' ? 'selected' : ''; ?>>Türkçe</option>
                        <option value="de" <?php echo $lang == 'de' ? 'selected' : ''; ?>>Deutsch</option>
                        <option value="fr" <?php echo $lang == 'fr' ? 'selected' : ''; ?>>Français</option>
                    </select>
                </div>
                
                <!-- انتخابگر تم -->
                <div class="theme-selector">
                    <button class="theme-btn" onclick="toggleTheme()">
                        <i class="fas fa-palette"></i>
                    </button>
                </div>
            </div>
        </div>
    </nav>

    <!-- منوی موبایل -->
    <div class="mobile-nav">
        <a href="<?php echo SITE_URL; ?>" class="mobile-nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : ''; ?>">
            <i class="fas fa-home"></i>
            <span>خانه</span>
        </a>
        <a href="<?php echo SITE_URL; ?>/casino.php" class="mobile-nav-item">
            <i class="fas fa-dice"></i>
            <span>کازینو</span>
        </a>
        <a href="<?php echo SITE_URL; ?>/sports.php" class="mobile-nav-item">
            <i class="fas fa-trophy"></i>
            <span>ورزشی</span>
        </a>
        <a href="<?php echo SITE_URL; ?>/live.php" class="mobile-nav-item">
            <i class="fas fa-video"></i>
            <span>زنده</span>
        </a>
        <?php if ($auth->isLoggedIn()): ?>
            <a href="<?php echo SITE_URL; ?>/wallet.php" class="mobile-nav-item">
                <i class="fas fa-wallet"></i>
                <span>کیف پول</span>
            </a>
        <?php else: ?>
            <a href="<?php echo SITE_URL; ?>/login.php" class="mobile-nav-item">
                <i class="fas fa-user"></i>
                <span>حساب کاربری</span>
            </a>
        <?php endif; ?>
    </div>

    <!-- محتوای اصلی -->
    <main class="main-content">