<?php
require_once '../includes/config.php';
require_once '../includes/db.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

$functions = new Functions();
$response = array('success' => false, 'message' => '');

// بررسی درخواست AJAX
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    switch ($action) {
        case 'start_game':
            // شروع بازی جدید
            $game_data = $functions->startGame();
            $_SESSION['current_game'] = $game_data;
            $query = "INSERT INTO games (bet_amount, crashed_at) VALUES (0, :crashed_at)";
            $response['success'] = true;
            $response['game_id'] = $game_data['game_id'];
            $response['multiplier'] = $game_data['multiplier'];
            break;
            
        case 'place_bet':
            // ثبت شرط
            if (isset($_SESSION['user_id'])) {
                $user_id = $_SESSION['user_id'];
                $game_id = $_POST['game_id'];
                $amount = floatval($_POST['amount']);
                $auto_cashout = isset($_POST['auto_cashout']) ? floatval($_POST['auto_cashout']) : null;
                
                // بررسی محدودیت شرط
                $min_bet = $functions->getSetting('min_bet');
                $max_bet = $functions->getSetting('max_bet');
                
                if ($amount < $min_bet || $amount > $max_bet) {
                    $response['message'] = "Bet amount must be between $min_bet and $max_bet";
                } else {
                    $result = $functions->placeBet($user_id, $game_id, $amount, $auto_cashout);
                    
                    if ($result) {
                        $response['success'] = true;
                        $response['message'] = "Bet placed successfully";
                        $response['new_balance'] = $_SESSION['balance'] - $amount;
                        $_SESSION['balance'] = $response['new_balance'];
                    } else {
                        $response['message'] = "Failed to place bet";
                    }
                }
            } else {
                $response['message'] = "You must be logged in to place a bet";
            }
            break;
            
        case 'cashout':
            // نقد کردن شرط
            if (isset($_SESSION['user_id'])) {
                $user_id = $_SESSION['user_id'];
                $game_id = $_POST['game_id'];
                $multiplier = floatval($_POST['multiplier']);
                
                $win_amount = $functions->cashout($user_id, $game_id, $multiplier);
                
                if ($win_amount !== false) {
                    $response['success'] = true;
                    $response['message'] = "Cashed out at " . $multiplier . "x";
                    $response['win_amount'] = $win_amount;
                    $response['new_balance'] = $_SESSION['balance'] + $win_amount;
                    $_SESSION['balance'] = $response['new_balance'];
                } else {
                    $response['message'] = "Failed to cashout";
                }
            } else {
                $response['message'] = "You must be logged in to cashout";
            }
            break;
            
        case 'get_game_status':
            // دریافت وضعیت بازی
            $game_id = $_POST['game_id'] ?? 0;
            
            $query = "SELECT g.id, g.crashed_at, g.created_at, 
                             COUNT(b.id) as bet_count, 
                             SUM(b.amount) as total_bet,
                             MAX(b.cashed_out) as max_cashout
                      FROM games g 
                      LEFT JOIN bets b ON g.id = b.game_id 
                      WHERE g.id = :game_id 
                      GROUP BY g.id";
            $stmt = $functions->db->prepare($query);
            $stmt->bindParam(":game_id", $game_id);
            $stmt->execute();
            
            if ($stmt->rowCount() > 0) {
                $game = $stmt->fetch();
                $response['success'] = true;
                $response['game'] = $game;
            } else {
                $response['message'] = "Game not found";
            }
            break;
            
        default:
            $response['message'] = "Invalid action";
            break;
    }
} else {
    $response['message'] = "Invalid request method";
}

echo json_encode($response);
?>