<?php
require_once 'header.php';

// بررسی دسترسی ادمین
if (!$auth->isAdmin()) {
    header("Location: login.php");
    exit;
}

// دریافت تنظیمات از دیتابیس
$query = "SELECT * FROM settings";
$stmt = $db->prepare($query);
$stmt->execute();
$settings = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);

// پردازش فرم ارسال شده
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    foreach ($_POST as $key => $value) {
        if (strpos($key, 'setting_') === 0) {
            $settingKey = substr($key, 8);
            $settingValue = trim($value);
            
            // به روز رسانی تنظیم در دیتابیس
            $updateQuery = "INSERT INTO settings (`key`, `value`) 
                            VALUES (:key, :value) 
                            ON DUPLICATE KEY UPDATE `value` = :value";
            $updateStmt = $db->prepare($updateQuery);
            $updateStmt->bindParam(':key', $settingKey);
            $updateStmt->bindParam(':value', $settingValue);
            $updateStmt->execute();
        }
    }
    
    $_SESSION['success'] = "تنظیمات با موفقیت به روز شد.";
    header("Location: settings.php");
    exit;
}
?>

<div class="admin-content">
    <h1>تنظیمات سایت</h1>
    
    <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success"><?php echo $_SESSION['success']; unset($_SESSION['success']); ?></div>
    <?php endif; ?>
    
    <form method="POST">
        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title">تنظیمات عمومی</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="setting_site_name">نام سایت</label>
                            <input type="text" id="setting_site_name" name="setting_site_name" 
                                   class="form-control" value="<?php echo htmlspecialchars($settings['site_name'] ?? ''); ?>">
                        </div>
                        
                        <div class="form-group">
                            <label for="setting_default_language">زبان پیش‌فرض</label>
                            <select id="setting_default_language" name="setting_default_language" class="form-select">
                                <option value="en" <?php echo ($settings['default_language'] ?? 'en') == 'en' ? 'selected' : ''; ?>>English</option>
                                <option value="fa" <?php echo ($settings['default_language'] ?? 'en') == 'fa' ? 'selected' : ''; ?>>فارسی</option>
                                <option value="ar" <?php echo ($settings['default_language'] ?? 'en') == 'ar' ? 'selected' : ''; ?>>العربية</option>
                                <option value="tr" <?php echo ($settings['default_language'] ?? 'en') == 'tr' ? 'selected' : ''; ?>>Türkçe</option>
                                <option value="de" <?php echo ($settings['default_language'] ?? 'en') == 'de' ? 'selected' : ''; ?>>Deutsch</option>
                                <option value="fr" <?php echo ($settings['default_language'] ?? 'en') == 'fr' ? 'selected' : ''; ?>>Français</option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label for="setting_maintenance_mode">حالت نگهداری</label>
                            <select id="setting_maintenance_mode" name="setting_maintenance_mode" class="form-select">
                                <option value="0" <?php echo ($settings['maintenance_mode'] ?? '0') == '0' ? 'selected' : ''; ?>>غیر فعال</option>
                                <option value="1" <?php echo ($settings['maintenance_mode'] ?? '0') == '1' ? 'selected' : ''; ?>>فعال</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title">تنظیمات بازی</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="setting_min_bet">حداقل شرط</label>
                            <input type="number" id="setting_min_bet" name="setting_min_bet" 
                                   class="form-control" step="0.01" min="0.01" 
                                   value="<?php echo htmlspecialchars($settings['min_bet'] ?? '1'); ?>">
                        </div>
                        
                        <div class="form-group">
                            <label for="setting_max_bet">حداکثر شرط</label>
                            <input type="number" id="setting_max_bet" name="setting_max_bet" 
                                   class="form-control" step="0.01" min="1" 
                                   value="<?php echo htmlspecialchars($settings['max_bet'] ?? '1000'); ?>">
                        </div>
                        
                        <div class="form-group">
                            <label for="setting_house_edge">درصد House Edge</label>
                            <input type="number" id="setting_house_edge" name="setting_house_edge" 
                                   class="form-control" step="0.01" min="0" max="10" 
                                   value="<?php echo htmlspecialchars($settings['house_edge'] ?? '2'); ?>">
                            <small class="form-text text-muted">این درصد از سود کاربران کسر می‌شود.</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row mt-4">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title">تنظیمات مالی</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="setting_min_deposit">حداقل واریز</label>
                            <input type="number" id="setting_min_deposit" name="setting_min_deposit" 
                                   class="form-control" step="0.01" min="1" 
                                   value="<?php echo htmlspecialchars($settings['min_deposit'] ?? '5'); ?>">
                        </div>
                        
                        <div class="form-group">
                            <label for="setting_max_deposit">حداکثر واریز</label>
                            <input type="number" id="setting_max_deposit" name="setting_max_deposit" 
                                   class="form-control" step="0.01" min="10" 
                                   value="<?php echo htmlspecialchars($settings['max_deposit'] ?? '5000'); ?>">
                        </div>
                        
                        <div class="form-group">
                            <label for="setting_min_withdraw">حداقل برداشت</label>
                            <input type="number" id="setting_min_withdraw" name="setting_min_withdraw" 
                                   class="form-control" step="0.01" min="1" 
                                   value="<?php echo htmlspecialchars($settings['min_withdraw'] ?? '10'); ?>">
                        </div>
                        
                        <div class="form-group">
                            <label for="setting_max_withdraw">حداکثر برداشت</label>
                            <input type="number" id="setting_max_withdraw" name="setting_max_withdraw" 
                                   class="form-control" step="0.01" min="10" 
                                   value="<?php echo htmlspecialchars($settings['max_withdraw'] ?? '5000'); ?>">
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title">تنظیمات پیامک و ایمیل</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="setting_smtp_host">SMTP Host</label>
                            <input type="text" id="setting_smtp_host" name="setting_smtp_host" 
                                   class="form-control" value="<?php echo htmlspecialchars($settings['smtp_host'] ?? ''); ?>">
                        </div>
                        
                        <div class="form-group">
                            <label for="setting_smtp_port">SMTP Port</label>
                            <input type="number" id="setting_smtp_port" name="setting_smtp_port" 
                                   class="form-control" value="<?php echo htmlspecialchars($settings['smtp_port'] ?? '587'); ?>">
                        </div>
                        
                        <div class="form-group">
                            <label for="setting_smtp_username">SMTP Username</label>
                            <input type="text" id="setting_smtp_username" name="setting_smtp_username" 
                                   class="form-control" value="<?php echo htmlspecialchars($settings['smtp_username'] ?? ''); ?>">
                        </div>
                        
                        <div class="form-group">
                            <label for="setting_smtp_password">SMTP Password</label>
                            <input type="password" id="setting_smtp_password" name="setting_smtp_password" 
                                   class="form-control" value="<?php echo htmlspecialchars($settings['smtp_password'] ?? ''); ?>">
                        </div>
                        
                        <div class="form-group">
                            <label for="setting_sms_api_key">SMS API Key</label>
                            <input type="text" id="setting_sms_api_key" name="setting_sms_api_key" 
                                   class="form-control" value="<?php echo htmlspecialchars($settings['sms_api_key'] ?? ''); ?>">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="mt-4">
            <button type="submit" class="btn btn-primary">ذخیره تنظیمات</button>
            <button type="reset" class="btn btn-secondary">بازنشانی</button>
        </div>
    </form>
</div>

<?php
require_once 'footer.php';
?>